function [ cp ] = prdspl( Mrd1d2,c1,c2 )
%Find coeff of product spline in S^r_{d1+d2} of splines in S^r_{d1,d2}
%   c1 and c2 represent two splines in S^{r}_{d1}(orig_delta) and
%   S^{r}_{d2}(orig_delta) respectively.  Mrd1d2 is the output of
%   prdspl_aux. The output cp is row vector of coefficients for the
%   B-spline basis.

%(c1d1N1d1+...+cn1d1Nn1d1)*(c1d2N1d2+...+cn2d2Nn2d2) = 
%\sum (cid1*cjd2)*(Nid1*Njd2)

n1 = size(c1,2);
n2 = size(c2,2);
np = size(Mrd1d2,3);

cp = zeros(1,np);

storage = zeros(1,1,np); %Intermediary storage because want final answer to
                         %be a row vector.
                       
for i=1:n1
    for j=1:n2
        storage = storage + c1(1,i)*c2(1,j)*Mrd1d2(i,j,:);
    end
end

for i=1:np
    cp(1,i) = storage(1,1,i);
end


end

